<?php
$message = '';
$expiration_datetime = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $expiration_datetime = $_POST['expiration_datetime'];

    if (validate_datetime_format($expiration_datetime)) {
        $config_file = '../ultimate/expiration_config.php';
        $config_content = '<?php return [\'expiration_datetime\' => \'' . $expiration_datetime . '\']; ?>';

        file_put_contents($config_file, $config_content);

        $message = 'Waktu Sudah Berhasil Di Ganti.';
    } else {
        $message = 'Format datetime tidak valid. Masukkan dalam format yyyy-mm-dd HH:ii (contoh: 2025-06-23 14:30).';
    }
}

function validate_datetime_format($datetime) {
    $d = DateTime::createFromFormat('Y-m-d H:i', $datetime);
    return $d && $d->format('Y-m-d H:i') === $datetime;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Atur Waktu Kadaluarsa</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.css">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">Atur Waktu Kadaluarsa</div>
                    <div class="card-body">
                        <?php if (!empty($message)) : ?>
                            <div class="alert alert-<?php echo (strpos($message, 'tidak valid') !== false) ? 'danger' : 'success'; ?>" role="alert">
                                <?= $message ?>
                            </div>
                        <?php endif; ?>
                        <form method="POST">
                            <div class="form-group">
                                <label for="expiration_datetime">Waktu Kadaluarsa:</label>
                                <input type="text" class="form-control" id="expiration_datetime" name="expiration_datetime" value="<?= htmlspecialchars($expiration_datetime); ?>" required>
                                <small id="expirationHelp" class="form-text text-muted">Format: yyyy-mm-dd HH:ii (contoh: 2025-06-23 14:30)</small>
                            </div>
                            <?php if (!empty($message) && strpos($message, 'tidak valid') !== false) : ?>
                                <div class="alert alert-danger" role="alert">
                                    Format datetime tidak valid. Pastikan untuk memasukkan dalam format yyyy-mm-dd HH:ii (contoh: 2024-06-23 14:30).
                                </div>
                            <?php endif; ?>
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
    <script>
        // Tampilkan sweetalert jika ada pesan berhasil
        <?php if (!empty($message) && strpos($message, 'berhasil') !== false) : ?>
            swal({
                title: "Berhasil!",
                text: "<?= $message ?>",
                icon: "success",
                button: "OK"
            });
        <?php endif; ?>
    </script>
</body>
</html>
