<?php
session_start();

$valid_users = [
    'PADUKA08' => password_hash('PADUKA08', PASSWORD_DEFAULT),
];

if (isset($_SESSION['logged_in']) && $_SESSION['logged_in']) {
    header('Location: Paduka.php');
    exit;
}

$login_failed = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (array_key_exists($username, $valid_users) && password_verify($password, $valid_users[$username])) {
        $_SESSION['logged_in'] = true;
        $_SESSION['username'] = $username;
        header('Location: Mangzax.php');
        exit;
    } else {
        $login_failed = true;
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Login Panel</title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css"/>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css"/>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    body {
      background: linear-gradient(135deg, #6a11cb, #2575fc);
      height: 100vh;
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      display: flex;
      justify-content: center;
      align-items: center;
      animation: fadeIn 1s ease-in;
    }
    .login-form {
      width: 100%;
      max-width: 400px;
      background: rgba(255, 255, 255, 0.95);
      padding: 30px;
      border-radius: 20px;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.25);
      animation: slideUp 0.7s ease-out;
    }
    @keyframes slideUp {
      from { transform: translateY(40px); opacity: 0; }
      to { transform: translateY(0); opacity: 1; }
    }
    @keyframes fadeIn {
      from { opacity: 0; }
      to { opacity: 1; }
    }
    .input-group-text {
      background: #fff;
      border-right: none;
    }
    .form-control {
      border-left: none;
    }
    .btn-primary {
      background-color: #6a11cb;
      border: none;
      border-radius: 8px;
      font-weight: bold;
      transition: background-color 0.3s ease;
    }
    .btn-primary:hover {
      background-color: #4b0dab;
    }
    .toggle-password {
      cursor: pointer;
    }
  </style>
</head>
<body>

<div class="login-form">
  <h4 class="text-center mb-4"><i class="fas fa-user-circle"></i> LOGIN PANEL</h4>
  <form method="POST" action="<?= htmlspecialchars($_SERVER['PHP_SELF']); ?>" autocomplete="off">
    <div class="form-group">
      <div class="input-group">
        <div class="input-group-prepend">
          <span class="input-group-text"><i class="fas fa-user"></i></span>
        </div>
        <input type="text" name="username" class="form-control" placeholder="Username" required />
      </div>
    </div>
    <div class="form-group">
      <div class="input-group">
        <div class="input-group-prepend">
          <span class="input-group-text"><i class="fas fa-lock"></i></span>
        </div>
        <input type="password" name="password" class="form-control" id="passwordInput" placeholder="Password" required />
        <div class="input-group-append">
          <span class="input-group-text toggle-password"><i class="fas fa-eye" id="toggleIcon"></i></span>
        </div>
      </div>
    </div>
    <button type="submit" class="btn btn-primary btn-block">Masuk</button>
  </form>
</div>

<?php if ($login_failed): ?>
<script>
  Swal.fire({
    icon: 'error',
    title: 'Login Gagal',
    text: 'Mau Ngapain Lu ?',
    showClass: {
      popup: 'animate__animated animate__shakeX'
    },
    confirmButtonColor: '#d33'
  });
</script>
<?php endif; ?>

<!-- Scripts -->
<script>
  const togglePassword = document.querySelector('.toggle-password');
  const passwordInput = document.getElementById('passwordInput');
  const toggleIcon = document.getElementById('toggleIcon');

  togglePassword.addEventListener('click', () => {
    const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
    passwordInput.setAttribute('type', type);
    toggleIcon.classList.toggle('fa-eye');
    toggleIcon.classList.toggle('fa-eye-slash');
  });
</script>
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@1.16.0/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>